class OneOnOne_SB extends TournamentScoreBoard;

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var myPRI Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 58.0/768.0 * Canvas.ClipY;
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart);
		Canvas.DrawText(GRI.GameEndedComments, True);
	}
	else
	{
		Canvas.SetPos(0, ScoreStart);
		DrawVictoryConditions(Canvas);
	}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, 16);
	Canvas.DrawText(TGRI.GameName);
	
	Canvas.SetPos(0, 16 + YL);

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.SetPos(0, 16 + 2 * YL);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawCategoryHeaders(Canvas Canvas)
{

}

simulated function DrawBigNum(Canvas Canvas, int Value, int X, int Y, optional float ScaleFactor)
{
	local int d, Mag, Step;
	local float UpScale;
	local byte bMinus;

	if ( ScaleFactor != 0 )
		UpScale = ScaleFactor;
	else
		UpScale = 1;

	Canvas.CurX = X;	
	Canvas.CurY = Y;
	Step = 16 * UpScale;
	if ( Value < 0 )
		bMinus = 1;
	Mag = FMin(9999, Abs(Value));

	if ( Mag >= 1000 )
	{
		Canvas.CurX -= Step;
		d = 0.001 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 1000 * d;
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else if ( Mag >= 100 )
	{
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else
		Canvas.CurX += Step;

	if ( Mag >= 10 )
	{
		d = 0.1 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 10 * d;
	}
	else if ( d > 0 )
		DrawDigit(Canvas, 0, Step, UpScale, bMinus);
	else
		Canvas.CurX += Step;

	DrawDigit(Canvas, Mag, Step, UpScale, bMinus);
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

function xxDrawFirstPlayer(Canvas zzCanvas, myPRI zzPRI, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL;
local float zzEff, zzATS, zzATD;
local int zzHours, zzMinutes, zzSeconds, zzTime;

	zzSeconds = zzPRI.TotalTime;
	zzMinutes = zzSeconds / 60;
	zzHours   = zzMinutes / 60;
	zzSeconds = zzSeconds - (zzMinutes * 60);
	zzMinutes = zzMinutes - (zzHours * 60);

	//Draw Frame:
	zzCanvas.Style = ERenderStyle.STY_Translucent;
	zzCanvas.DrawColor.R = 90;
	zzCanvas.DrawColor.G = 90;
	zzCanvas.DrawColor.B = 90;
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 - 322, YOffset - 2);
	zzCanvas.DrawTile(Texture'BackGround', 314, 2, 0, 0, 314, 2);
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 - 322, YOffset );
	zzCanvas.DrawTile(Texture'BackGround', 2, 322, 0, 0, 2, 322);
	zzCanvas.DrawColor.R = 30;
	zzCanvas.DrawColor.G = 30;
	zzCanvas.DrawColor.B = 30;
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 - 10, YOffset);
	zzCanvas.DrawTile(Texture'BackGround', 2, 322, 0, 0, 24, 322);
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 - 320, YOffset + 320 );
	zzCanvas.DrawTile(Texture'BackGround', 310, 2, 0, 0, 310, 2);
	zzCanvas.DrawColor.R = 50;
	zzCanvas.DrawColor.G = 50;
	zzCanvas.DrawColor.B = 50;
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 - 320, YOffset);
	zzCanvas.DrawTile(Texture'BackGround', 310, 320, 0, 0, 310, 320);

	zzCanvas.Style = ERenderStyle.STY_Normal;
	zzCanvas.Font = MyFonts.GetBigFont(zzCanvas.ClipX);

	zzCanvas.DrawColor = GoldColor;

/*	310 20 310	*/

	YOffset += 8;

	//Draw Name:
	zzCanvas.StrLen( zzPRI.PlayerName, XL, YL );
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 - 160 - 0.5 * XL, YOffset );
	zzCanvas.DrawText(zzPRI.PlayerName, False);

	zzCanvas.Font = MyFonts.GetSmallFont(zzCanvas.ClipX);
	zzCanvas.StrLen( "TEST", XL, YL );
	YL -= 2;

	//Draw score:
	zzCanvas.DrawColor = GreenColor;
	DrawBigNum(zzCanvas, int(zzPRI.Score), zzCanvas.ClipX * 0.5 - 328, YOffset - 8, 1);
	zzCanvas.DrawColor = GoldColor;
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 2 * YL);
	zzCanvas.DrawText("All time Score:"@zzPRI.AllTimeScore, false );

	// Draw Deaths
	zzCanvas.DrawColor = RedColor;
	DrawBigNum(zzCanvas, int(zzPRI.Deaths), zzCanvas.ClipX * 0.5 - 72, YOffset - 8, 1);
	zzCanvas.DrawColor = GoldColor;
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 3 * YL );
	zzCanvas.DrawText("All time Deaths:"@zzPRI.AllTimeDeaths, false );

	// Draw Eff:
	zzATS = zzPRI.AllTimeScore;
	zzATD = zzPRI.AllTimeDeaths;
	if ( zzATS < 0 )
		zzATS = 0;
	zzEff = zzATS / (zzATS + zzATD) * 100;
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 4 * YL );
	zzCanvas.DrawText("All time Eff:"@int(zzEff)$"%", false );

	// Draw wins and losses:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 5 * YL );
	zzCanvas.DrawText("Matches wun:"@zzPRI.Wins, false );
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 6 * YL );
	zzCanvas.DrawText("Matches lost:"@zzPRI.Losses, false );

	// Draw Headshots:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 7 * YL );
	zzCanvas.DrawText("Headshots:"@zzPRI.Headshots, false );

	// Draw first bloods:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 8 * YL );
	zzCanvas.DrawText("First Bloods:"@zzPRI.FirstBlood, false );

	// Draw Suicides:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 9 * YL );
	zzCanvas.DrawText("Suicides:"@int(zzPRI.Suicides * 0.5), false );

	// Draw Killingspees:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 10 * YL );
	zzCanvas.DrawText("Killing sprees:"@zzPRI.KillingSpree, false );

	// Draw Rampage:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 11 * YL );
	zzCanvas.DrawText("Rampage sprees:"@zzPRI.Rampage, false );

	// Draw Dominating:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 12 * YL );
	zzCanvas.DrawText("Dominating sprees:"@zzPRI.Dominating, false );

	// Draw Unstopable:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 13 * YL );
	zzCanvas.DrawText("Unstopable sprees:"@zzPRI.Unstopable, false );

	// Draw godlike:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 14 * YL );
	zzCanvas.DrawText("Godlike sprees:"@zzPRI.godlike, false );

	// Draw Time Online:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 15 * YL );
	zzCanvas.DrawText("Time on server:"@zzHours$":"$TwoDigitString(zzMinutes)$":"$TwoDigitString(zzSeconds), false );

	// Draw Rank on server:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 310, YOffset + 16 * YL );
	if ( zzPRI.Wins + zzPRI.Losses < 10 )
		zzCanvas.DrawText("Rank on server: Not ranked yet.", false );
	else
		zzCanvas.DrawText("Rank on server:"@zzPRI.Rank$"/"$zzPRI.NumRanked, false );

/* --------------- Draw tiny stuff: -------------- */

	zzCanvas.Font = MyFonts.GetAReallySmallFont(zzCanvas.ClipX);
	zzTime = Max(1, (Level.TimeSeconds + PlayerPawn(Owner).PlayerReplicationInfo.StartTime - zzPRI.StartTime)/60);
	zzCanvas.StrLen( TimeString$":"@zzTime$", "$FPHString$": "@int(60 * zzPRI.Score/zzTime)$", "$PingString$":"@zzPRI.Ping, XL, YL );
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 - 160 - 0.5 * XL, YOffset + 312 - YL );
	zzCanvas.DrawText( TimeString$":"@zzTime$", "$FPHString$": "@int(60 * zzPRI.Score/zzTime)$", "$PingString$":"@zzPRI.Ping, false );
}

function xxDrawSecondPlayer(Canvas zzCanvas, myPRI zzPRI, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL;
local float zzEff, zzATS, zzATD;
local int zzHours, zzMinutes, zzSeconds, zzTime;

	zzSeconds = zzPRI.TotalTime;
	zzMinutes = zzSeconds / 60;
	zzHours   = zzMinutes / 60;
	zzSeconds = zzSeconds - (zzMinutes * 60);
	zzMinutes = zzMinutes - (zzHours * 60);

	//Draw Frame:
	zzCanvas.Style = ERenderStyle.STY_Translucent;
	zzCanvas.DrawColor.R = 90;
	zzCanvas.DrawColor.G = 90;
	zzCanvas.DrawColor.B = 90;
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 + 8, YOffset - 2);
	zzCanvas.DrawTile(Texture'BackGround', 314, 2, 0, 0, 314, 2);
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 + 8, YOffset );
	zzCanvas.DrawTile(Texture'BackGround', 2, 322, 0, 0, 2, 322);
	zzCanvas.DrawColor.R = 30;
	zzCanvas.DrawColor.G = 30;
	zzCanvas.DrawColor.B = 30;
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 + 320, YOffset);
	zzCanvas.DrawTile(Texture'BackGround', 2, 322, 0, 0, 24, 322);
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 + 10, YOffset + 320 );
	zzCanvas.DrawTile(Texture'BackGround', 310, 2, 0, 0, 310, 2);
	zzCanvas.DrawColor.R = 50;
	zzCanvas.DrawColor.G = 50;
	zzCanvas.DrawColor.B = 50;
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 + 10, YOffset);
	zzCanvas.DrawTile(Texture'BackGround', 310, 320, 0, 0, 310, 320);

	zzCanvas.Style = ERenderStyle.STY_Normal;
	zzCanvas.Font = MyFonts.GetBigFont(zzCanvas.ClipX);

	zzCanvas.DrawColor = GoldColor;

/*	310 20 310	*/

	YOffset += 8;

	//Draw Name:
	zzCanvas.StrLen( zzPRI.PlayerName, XL, YL );
	zzCanvas.SetPos(zzCanvas.ClipX * 0.5 + 160 - 0.5 * XL, YOffset );
	zzCanvas.DrawText(zzPRI.PlayerName, False);

	zzCanvas.Font = MyFonts.GetSmallFont(zzCanvas.ClipX);
	zzCanvas.StrLen( "TEST", XL, YL );
	YL -= 2;

	//Draw score:
	zzCanvas.DrawColor = GreenColor;
	DrawBigNum(zzCanvas, int(zzPRI.Score), zzCanvas.ClipX * 0.5 + 2, YOffset - 8, 1);
	zzCanvas.DrawColor = GoldColor;
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 2 * YL);
	zzCanvas.DrawText("All time Score:"@zzPRI.AllTimeScore, false );

	// Draw Deaths
	zzCanvas.DrawColor = RedColor;
	DrawBigNum(zzCanvas, int(zzPRI.Deaths), zzCanvas.ClipX * 0.5 + 258, YOffset - 8, 1);
	zzCanvas.DrawColor = GoldColor;
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 3 * YL );
	zzCanvas.DrawText("All time Deaths:"@zzPRI.AllTimeDeaths, false );

	// Draw Eff:
	zzATS = zzPRI.AllTimeScore;
	zzATD = zzPRI.AllTimeDeaths;
	if ( zzATS < 0 )
		zzATS = 0;
	zzEff = zzATS / (zzATS + zzATD) * 100;
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 4 * YL );
	zzCanvas.DrawText("All time Eff:"@int(zzEff)$"%", false );

	// Draw wins and losses:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 5 * YL );
	zzCanvas.DrawText("Matches wun:"@zzPRI.Wins, false );
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 6 * YL );
	zzCanvas.DrawText("Matches lost:"@zzPRI.Losses, false );

	// Draw Headshots:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 7 * YL );
	zzCanvas.DrawText("Headshots:"@zzPRI.Headshots, false );

	// Draw first bloods:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 8 * YL );
	zzCanvas.DrawText("First Bloods:"@zzPRI.FirstBlood, false );

	// Draw Suicides:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 9 * YL );
	zzCanvas.DrawText("Suicides:"@int(zzPRI.Suicides * 0.5), false );

	// Draw Killingspees:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 10 * YL );
	zzCanvas.DrawText("Killing sprees:"@zzPRI.KillingSpree, false );

	// Draw Rampage:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 11 * YL );
	zzCanvas.DrawText("Rampage sprees:"@zzPRI.Rampage, false );

	// Draw Dominating:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 12 * YL );
	zzCanvas.DrawText("Dominating sprees:"@zzPRI.Dominating, false );

	// Draw Unstopable:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 13 * YL );
	zzCanvas.DrawText("Unstopable sprees:"@zzPRI.Unstopable, false );

	// Draw godlike:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 14 * YL );
	zzCanvas.DrawText("Godlike sprees:"@zzPRI.godlike, false );

	// Draw Time Online:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 15 * YL );
	zzCanvas.DrawText("Time on server:"@zzHours$":"$TwoDigitString(zzMinutes)$":"$TwoDigitString(zzSeconds), false );

	// Draw Rank on server:
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 18, YOffset + 16 * YL );
	if ( zzPRI.Wins + zzPRI.Losses < 10 )
		zzCanvas.DrawText("Rank on server: Not ranked yet.", false );
	else
		zzCanvas.DrawText("Rank on server:"@zzPRI.Rank$"/"$zzPRI.NumRanked, false );

/* --------------- Draw tiny stuff: -------------- */

	zzCanvas.Font = MyFonts.GetAReallySmallFont(zzCanvas.ClipX);
	zzTime = Max(1, (Level.TimeSeconds + PlayerPawn(Owner).PlayerReplicationInfo.StartTime - zzPRI.StartTime)/60);
	zzCanvas.StrLen( TimeString$":"@zzTime$", "$FPHString$": "@int(60 * zzPRI.Score/zzTime)$", "$PingString$":"@zzPRI.Ping, XL, YL );
	zzCanvas.SetPos( zzCanvas.ClipX * 0.5 + 160 - 0.5 * XL, YOffset + 312 - YL );
	zzCanvas.DrawText( TimeString$":"@zzTime$", "$FPHString$": "@int(60 * zzPRI.Score/zzTime)$", "$PingString$":"@zzPRI.Ping, false );
}

function SortScores(int N)
{
	local int I, J, Max;
	local myPRI TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local myPRI PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<2; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = myPRI(PlayerPawn(Owner).GameReplicationInfo.PRIArray[i]);
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	//SortScores(PlayerCount);
	
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	DrawCategoryHeaders(Canvas);

	Canvas.SetPos(0, 0);

	YOffset = 160;
	xxDrawFirstPlayer( Canvas, Ordered[0], 0, YOffset, false );
	xxDrawSecondPlayer( Canvas, Ordered[1], 0, YOffset, false );

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
}
